<?php

class ControllerExtensionPaymentIveri extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/payment/iveri');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_iveri', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['iveri_application_id'])) {
            $data['error_iveri_application_id'] = $this->error['iveri_application_id'];
        } else {
            $data['error_iveri_application_id'] = '';
        }

        if (isset($this->error['iveri_application_url'])) {
            $data['error_iveri_application_url'] = $this->error['iveri_application_url'];
        } else {
            $data['error_iveri_application_url'] = '';
        }

        if (isset($this->error['signature'])) {
            $data['error_signature'] = $this->error['signature'];
        } else {
            $data['error_signature'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_extension'),
                'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/payment/iveri', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/payment/iveri', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

        if (isset($this->request->post['payment_iveri_application_id'])) {
                $data['payment_iveri_application_id'] = $this->request->post['payment_iveri_application_id'];
        } else {
                $data['payment_iveri_application_id'] = $this->config->get('payment_iveri_application_id');
        }

        if (isset($this->request->post['payment_iveri_application_url'])) {
            $data['payment_iveri_application_url'] = $this->request->post['payment_iveri_application_url'];
        } else {
            $data['payment_iveri_application_url'] = $this->config->get('payment_iveri_application_url');
        }

        if (isset($this->request->post['payment_iveri_sandbox'])) {
                $data['payment_iveri_sandbox'] = $this->request->post['payment_iveri_sandbox'];
        } else {
                $data['payment_iveri_sandbox'] = $this->config->get('payment_iveri_sandbox');
        }

        if (isset($this->request->post['payment_iveri_test_application_id'])) {
                $data['payment_iveri_test_application_id'] = $this->request->post['payment_iveri_test_application_id'];
        } else {
                $data['payment_iveri_test_application_id'] = $this->config->get('payment_iveri_test_application_id');
        }

        if (isset($this->request->post['payment_iveri_test_application_url'])) {
            $data['payment_iveri_test_application_url'] = $this->request->post['payment_iveri_test_application_url'];
        } else {
            $data['payment_iveri_test_application_url'] = $this->config->get('payment_iveri_test_application_url');
        }
        
        if (isset($this->request->post['payment_iveri_total'])) {
                $data['payment_iveri_total'] = $this->request->post['payment_iveri_total'];
        } else {
                $data['payment_iveri_total'] = $this->config->get('payment_iveri_total');
        }

        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        if (isset($this->request->post['payment_iveri_completed_status_id'])) {
            $data['payment_iveri_completed_status_id'] = $this->request->post['payment_iveri_completed_status_id'];
        } else {
            $data['payment_iveri_completed_status_id'] = $this->config->get('payment_iveri_completed_status_id');
        }

        if (isset($this->request->post['payment_iveri_failed_status_id'])) {
            $data['payment_iveri_failed_status_id'] = $this->request->post['payment_iveri_failed_status_id'];
        } else {
            $data['payment_iveri_failed_status_id'] = $this->config->get('payment_iveri_failed_status_id');
        }

        if (isset($this->request->post['payment_iveri_canceled_status_id'])) {
            $data['payment_iveri_canceled_status_id'] = $this->request->post['payment_iveri_canceled_status_id'];
        } else {
            $data['payment_iveri_canceled_status_id'] = $this->config->get('payment_iveri_canceled_status_id');
        }

        if (isset($this->request->post['payment_iveri_geo_zone_id'])) {
                $data['payment_iveri_geo_zone_id'] = $this->request->post['payment_iveri_geo_zone_id'];
        } else {
                $data['payment_iveri_geo_zone_id'] = $this->config->get('payment_iveri_geo_zone_id');
        }

        $this->load->model('localisation/geo_zone');

        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['payment_iveri_status'])) {
            $data['payment_iveri_status'] = $this->request->post['payment_iveri_status'];
        } else {
            $data['payment_iveri_status'] = $this->config->get('payment_iveri_status');
        }

        if (isset($this->request->post['payment_iveri_sort_order'])) {
                $data['payment_iveri_sort_order'] = $this->request->post['payment_iveri_sort_order'];
        } else {
                $data['payment_iveri_sort_order'] = $this->config->get('payment_iveri_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/iveri', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/iveri')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['payment_iveri_application_id']) {
            $this->error['iveri_application_id'] = $this->language->get('error_iveri_application_id');
        }

        if (!$this->request->post['payment_iveri_application_url']) {
            $this->error['iveri_application_url'] = $this->language->get('error_iveri_application_url');
        }

        return !$this->error;
    }

}
?>