<?php
class ControllerExtensionPaymentIveri extends Controller
{
    public function index()
    {
        $this->load->language( 'extension/payment/iveri' );

        $data[ 'text_sandbox' ] = $this->language->get( 'text_sandbox' );

        $data[ 'button_confirm' ] = $this->language->get( 'button_confirm' );

        $data[ 'sandbox' ] = $this->config->get( 'payment_iveri_sandbox' );

        $this->load->model( 'checkout/order' );

        $order_info = $this->model_checkout_order->getOrder( $this->session->data[ 'order_id' ] );

        if ( $order_info )
        {
            $order_info['currency_code'] = 'ZAR';

            if ( !$this->config->get( 'payment_iveri_sandbox' ) )
            {
                $application_id = $this->config->get( 'payment_iveri_application_id' );
                $application_url = $this->config->get( 'payment_iveri_application_url' );
            }
            else
            {
                $application_id = $this->config->get( 'payment_iveri_test_application_id' );
                $application_url = $this->config->get( 'payment_iveri_test_application_url' );
            }

            $data[ 'action' ] = $application_url;
            
            $return_url = $this->url->link( 'extension/payment/iveri/confirm', '', true );
            $cancel_url = $this->url->link( 'extension/payment/iveri/confirm', '', true );
            $name_first = html_entity_decode( $order_info[ 'payment_firstname' ], ENT_QUOTES, 'UTF-8' );
            $name_last = html_entity_decode( $order_info[ 'payment_lastname' ], ENT_QUOTES, 'UTF-8' );
            $email_address = $order_info[ 'email' ];
            $order_id = $this->session->data[ 'order_id' ];
            $amount = $this->currency->format( $order_info[ 'total' ], $order_info[ 'currency_code' ], '', false );
            $paytotal = $amount * 100;

            $payArray = array(
                'application_id' => $application_id, 'order_id' => $order_id, 'amount' => $paytotal,
                'return_url' => $return_url, 'cancel_url' => $cancel_url, 'name_first' => $name_first,
                'name_last' => $name_last, 'email_address' => $email_address
            );

            foreach ( $payArray as $k => $v )
            {
                $data[ $k ] = $v;
            }

            if ( file_exists( DIR_TEMPLATE . $this->config->get( 'config_template' ) . '/template/extension/payment/iveri' ) )
            {
                return $this->load->view( $this->config->get( 'config_template' ) . '/template/extension/payment/iveri',
                    $data );
            }
            else
            {
                return $this->load->view( 'extension/payment/iveri', $data );
            }

        }
    }

    /**
     * Confirm Order status
     */
    public function confirm()
    {
        $this->load->language('extension/payment/iveri');
		$this->load->model('checkout/order');

        if (isset($this->request->post['LITE_TRANSACTIONINDEX'])) {
        
            $order_id = $this->request->post['ECOM_CONSUMERORDERID'];
			
			$order_info = $this->model_checkout_order->getOrder($order_id);
            
            // Get order data
            $this->load->model( 'checkout/order' );
            $order_info = $this->model_checkout_order->getOrder( $order_id );

            if (isset($this->request->post["ECOM_PAYMENT_CARD_PROTOCOLS"])) {

                $iVeri = $this->request->post["ECOM_PAYMENT_CARD_PROTOCOLS"];

                if ($iVeri == 'iVeri') {
                    $iVeriResult = $this->request->post["LITE_PAYMENT_CARD_STATUS"];

                    $pay_result_desc = $this->request->post["LITE_RESULT_DESCRIPTION"];

                    switch ($iVeriResult) {
                        case 0:
                            $order_status_id = $this->config->get('payment_iveri_completed_status_id');
                            $this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
                            //$this->response->redirect($this->url->link('checkout/success', '', true));
                            echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/success', '', true) . "'</script>";
                            break;
                        case 1:
                        case 2:
                        case 5:
                        case 9:
                            $order_status_id = $this->config->get('payment_iveri_failed_status_id');
                            $this->session->data['error'] = "Transaction failed: ".$pay_result_desc;
							$this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
                            //$this->response->redirect($this->url->link('checkout/failure', '', true));
                            //echo "<script type='text/javascript'>alert('".$this->session->data['error']."');window.parent.location = '" . $this->url->link('checkout/checkout', '', true) . "'</script>";
                            echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/failure', '', true) . "'</script>";
                            break;
                        case 255:
                            $order_status_id = $this->config->get('payment_iveri_failed_status_id');
                            $this->session->data['error'] = "Transaction failed: ".$pay_result_desc;
							$this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
                            //$this->response->redirect($this->url->link('checkout/failure', '', true));
                            //echo "<script type='text/javascript'>alert('".$this->session->data['error']."');window.parent.location = '" . $this->url->link('checkout/checkout', '', true) . "'</script>";
                            echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/failure', '', true) . "'</script>";
                            break;
                        default:
                            $order_status_id = $this->config->get('payment_iveri_failed_status_id');
                            $this->session->data['error'] = "Transaction failed: ".$pay_result_desc;
							$this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
                            //$this->response->redirect($this->url->link('checkout/failure', '', true));
                            //echo "<script type='text/javascript'>alert('".$this->session->data['error']."');window.parent.location = '" . $this->url->link('checkout/checkout', '', true) . "'</script>";
                            echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/failure', '', true) . "'</script>";
                            break;
                    }
                } else {
                    $order_status_id = $this->config->get('payment_iveri_failed_status_id');
                    $this->session->data['error'] = "Transaction failed: Transaction type mismatch";
					$this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
                    //$this->response->redirect($this->url->link('checkout/checkout', '', true));
                    echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/failure', '', true) . "'</script>";
                }
            } else {
                $order_status_id = $this->config->get('payment_iveri_failed_status_id');
                $this->session->data['error'] = "Transaction failed: No Paymentcard Protocols.";
				$this->model_checkout_order->addOrderHistory($order_id, $order_status_id);
                //$this->response->redirect($this->url->link('checkout/checkout', '', true));
                echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/failure', '', true) . "'</script>";
            }
        } else {
            $order_status_id = $this->config->get('payment_iveri_failed_status_id');
            $this->session->data['error'] = "Transaction failed: No Transaction index.";
            //$this->response->redirect($this->url->link('checkout/checkout', '', true));
            echo "<script type='text/javascript'>window.parent.location = '" . $this->url->link('checkout/failure', '', true) . "'</script>";
        }
    }
}

?>